/*
	PictIIgs.r -- Type Declaration for RezIIgs and DeRezIIgs
	
	Copyright Apple Computer, Inc. 1986, 1987
	All rights reserved.

	This Picture resource definition should probably used
	for DeRezing purposes only.
	
	- Change history -
	12/21/88	- Mensch: created.
*/
#Define rPicture 	0x8002
type rPicture {
		integer Mode320 = 0, Mode640 =1;		/* SCB for picture */
		Rect;									/* Bounds of picture */
		Integer = 0x8211;						/* version */
				array OpCodes {
					switch {
						case Clip:
							key integer = $0001;
	ClipStart:				integer = (ClipEnd[$$ArrayIndex(OpCodes)] - ClipStart[$$ArrayIndex(OpCodes)]) >> 3;
							Rect;				/* region's enclosing rect */
							hex string [$$Word(ClipStart[$$ArrayIndex(OpCodes)]) - 10];
	ClipEnd:
						case BkPat:
							key integer = $0002;
							hex string [32];
						
						case TxFont:
							key integer = $0003;
							Longint;			/* font */
						
						case TxFace:
							key integer = $0004;
							unsigned hex Integer;	/* text face */
						
						case TxMode:
							key integer = $0005;
							integer		srcCopy, srcOr, srcXor, srcBic,	/* mode */
										notSrcCopy, notSrcOr, notSrcXor,
										notSrcBic, patCopy, patOr, patXor,
										patBic, notPatCopy, notPatOr, notPatBic;
						
						case SpExtra:
							key integer = $0006;
							unsigned hex longint;
						
						case PnSize:
							key integer = $0007;
							Point;
						
						case PnMode:
							key integer = $0008;
							unsigned hex integer;
						
						case PnPat:
							key integer = $0009;
							hex string [32];
						
						case FillPat:
							key integer = $000A;
							hex string [32];
						
						case OvSize:
							key integer = $000B;
							Point;
						
						case Origin:
							key integer = $000C;
							integer;			/* dh */
							integer;			/* dv */
						
						case TxSize:
							key integer = $000D;
							integer;
						
						case FgColor:
							key integer = $000E;
							Integer;
						
						case BkColor:
							key integer = $000F;
							Integer;
						
						case UNUSED10:
							key integer = $0010;
							Point;				/* numer */
							Point;				/* denom */
						
						case Version:
							key integer = $8211;

						case ChExtra:
							key integer = $0012;
							LongInt;

						case PnMask:
							key integer = $0013;
							hex string [8];

						case ArcRot:
							key integer = $0014;
							integer;
						
						case FontFlags:
							key integer = $0015;
							unsigned hex integer;
						
						case AppleReserved0016:
							key integer = $0016;
						
						case AppleReserved0017:
							key integer = $0017;
							
						case AppleReserved0018:
							key integer = $0018;
							
						case AppleReserved0019:
							key integer = $0019;
						
						case AppleReserved001A:
							key integer = $001A;
						
						case Line:
							key integer = $0020;
							Point;					/* pnLoc */
							Point;					/* newPt */
							
						case LineFrom:
							key integer = $0021;
							Point;					/* newPt */
						
						case ShortLine:
							key integer = $0022;
							Point;					/* pnLoc */
							byte;					/* dh */
							byte;					/* dv */
						
						case ShortLineFrom:
							key integer = $0023;
							byte;					/* dh */
							byte;					/* dv */
						
						case AppleReserved0024:
							key integer = $0024;
				AR24:		unsigned integer = (AR24End - AR24) / 8 - 2;
							hex string [$$Word(AR24)];
				AR24End:
						
						case AppleReserved0025:
							key integer = $0025;
				AR25:		unsigned integer = (AR25End - AR25) / 8 - 2;
							hex string [$$Word(AR25)];
				AR25End:
						
						case AppleReserved0026:
							key integer = $0026;
				AR26:		unsigned integer = (AR26End - AR26) / 8 - 2;
							hex string [$$Word(AR26)];
				AR26End:
						
						case AppleReserved0027:
							key integer = $0027;
				AR27:		unsigned integer = (AR27End - AR27) / 8 - 2;
							hex string [$$Word(AR27)];
				AR27End:
						
						case LongText:
							key integer = $0028;
							Point;				/* txLoc */
							pstring;			/* text */
						
						case DHText:
							key integer = $0029;
							byte;				/* dh */
							pstring;			/* text */

						case DVText:
							key integer = $002A;
							byte;				/* dv */
							pstring;			/* text */

						case DHDVText:
							key integer = $002B;
							byte;				/* dh */
							byte;				/* dv */
							pstring;			/* text */

						case RealLongText:
							key integer = $002C;
							point;
				AR2C:		unsigned integer = (AR2CEnd - AR2C) / 8 - 2;
							hex string [$$Word(AR2C)];
				AR2CEnd:
						
						case AppleReserved002D:
							key integer = $002D;
				AR2D:		unsigned integer = (AR2DEnd - AR2D) / 8 - 2;
							hex string [$$Word(AR2D)];
				AR2DEnd:
						
						case AppleReserved002E:
							key integer = $002E;
				AR2E:		unsigned integer = (AR2EEnd - AR2E) / 8 - 2;
							hex string [$$Word(AR2E)];
				AR2EEnd:
						
						case AppleReserved002F:
							key integer = $002F;
				AR2F:		unsigned integer = (AR2FEnd - AR2F) / 8 - 2;
							hex string [$$Word(AR2F)];
				AR2FEnd:
						
						case FrameRect:
							key integer = $0030;
							Rect;
							
						case PaintRect:
							key integer = $0031;
							Rect;
							
						case EraseRect:
							key integer = $0032;
							Rect;
							
						case InvertRect:
							key integer = $0033;
							Rect;
							
						case FillRect:
							key integer = $0034;
							Rect;
							
						case AppleReserved0035:
							key integer = $0035;
							Rect;
							
						case AppleReserved0036:
							key integer = $0036;
							Rect;
							
						case AppleReserved0037:
							key integer = $0037;
							Rect;
						
						case FrameSameRect:
							key integer = $0038;
						
						case PaintSameRect:
							key integer = $0039;
						
						case EraseSameRect:
							key integer = $003A;
						
						case InvertSameRect:
							key integer = $003B;
						
						case FillSameRect:
							key integer = $003C;
						
						case AppleReserved003D:
							key integer = $003D;
						
						case AppleReserved003E:
							key integer = $003E;
						
						case AppleReserved003F:
							key integer = $003F;
						
						case FrameRRect:
							key integer = $0040;
							Rect;
							
						case PaintRRect:
							key integer = $0041;
							Rect;
							
						case EraseRRect:
							key integer = $0042;
							Rect;
							
						case InvertRRect:
							key integer = $0043;
							Rect;
							
						case FillRRect:
							key integer = $0044;
							Rect;
							
						case AppleReserved0045:
							key integer = $0045;
							Rect;
							
						case AppleReserved0046:
							key integer = $0046;
							Rect;
							
						case AppleReserved0047:
							key integer = $0047;
							Rect;
						
						case FrameSameRRect:
							key integer = $0048;
						
						case PaintSameRRect:
							key integer = $0049;
						
						case EraseSameRRect:
							key integer = $004A;
						
						case InvertSameRRect:
							key integer = $004B;
						
						case FillSameRRect:
							key integer = $004C;
						
						case AppleReserved004D:
							key integer = $004D;
						
						case AppleReserved004E:
							key integer = $004E;
						
						case AppleReserved004F:
							key integer = $004F;
						
						case FrameOval:
							key integer = $0050;
							Rect;
							
						case PaintOval:
							key integer = $0051;
							Rect;
							
						case EraseOval:
							key integer = $0052;
							Rect;
							
						case InvertOval:
							key integer = $0053;
							Rect;
							
						case FillOval:
							key integer = $0054;
							Rect;
							
						case AppleReserved0055:
							key integer = $0055;
							Rect;
							
						case AppleReserved0056:
							key integer = $0056;
							Rect;
							
						case AppleReserved0057:
							key integer = $0057;
							Rect;
						
						case FrameSameOval:
							key integer = $0058;
						
						case PaintSameOval:
							key integer = $0059;
						
						case EraseSameOval:
							key integer = $005A;
						
						case InvertSameOval:
							key integer = $005B;
						
						case FillSameOval:
							key integer = $005C;
						
						case AppleReserved005D:
							key integer = $005D;
						
						case AppleReserved005E:
							key integer = $005E;
						
						case frameArc:
							key integer = $0060;
							Rect;
							integer;				/* startAngle */
							integer;				/* arcAngle */
						
						case paintArc:
							key integer = $0061;
							Rect;
							integer;				/* startAngle */
							integer;				/* arcAngle */
						
						case eraseArc:
							key integer = $0062;
							Rect;
							integer;				/* startAngle */
							integer;				/* arcAngle */
						
						case invertArc:
							key integer = $0063;
							Rect;
							integer;				/* startAngle */
							integer;				/* arcAngle */
						
						case fillArc:
							key integer = $0064;
							Rect;
							integer;				/* startAngle */
							integer;				/* arcAngle */
						
						case AppleReserved0065:
							key integer = $0065;
							Rect;
							integer;				/* startAngle */
							integer;				/* arcAngle */
						
						case AppleReserved0066:
							key integer = $0066;
							Rect;
							integer;				/* startAngle */
							integer;				/* arcAngle */
						
						case AppleReserved0067:
							key integer = $0067;
							Rect;
							integer;				/* startAngle */
							integer;				/* arcAngle */
						
						case frameSameArc:
							key integer = $0068;
							integer;				/* startAngle */
							integer;				/* arcAngle */

						case paintSameArc:
							key integer = $0069;
							integer;				/* startAngle */
							integer;				/* arcAngle */

						case eraseSameArc:
							key integer = $006A;
							integer;				/* startAngle */
							integer;				/* arcAngle */

						case invertSameArc:
							key integer = $006B;
							integer;				/* startAngle */
							integer;				/* arcAngle */

						case fillSameArc:
							key integer = $006C;
							integer;				/* startAngle */
							integer;				/* arcAngle */
						
						case AppleReserved006D:
							key integer = $006D;
							integer;				/* startAngle */
							integer;				/* arcAngle */
						
						case AppleReserved006E:
							key integer = $006E;
							integer;				/* startAngle */
							integer;				/* arcAngle */
						
						case AppleReserved006F:
							key integer = $006F;
							integer;				/* startAngle */
							integer;				/* arcAngle */
						
						case framePoly:
							key integer = $0070;
							integer = $$CountOf(framePoly) * 4 + 10;
							Rect;					/* enclosing rectangle */
							array framePoly {
								Point;
							};
						
						case paintPoly:
							key integer = $0071;
							integer = $$CountOf(framePoly) * 4 + 10;
							Rect;					/* enclosing rectangle */
							array framePoly {
								Point;
							};
						
						case erasePoly:
							key integer = $0072;
							integer = $$CountOf(framePoly) * 4 + 10;
							Rect;					/* enclosing rectangle */
							array framePoly {
								Point;
							};
						
						case invertPoly:
							key integer = $0073;
							integer = $$CountOf(framePoly) * 4 + 10;
							Rect;					/* enclosing rectangle */
							array framePoly {
								Point;
							};
						
						case fillPoly:
							key integer = $0074;
							integer = $$CountOf(framePoly) * 4 + 10;
							Rect;					/* enclosing rectangle */
							array framePoly {
								Point;
							};
						
						case AppleReserved0075:
							key integer = $0075;
							integer = $$CountOf(framePoly) * 4 + 10;
							Rect;					/* enclosing rectangle */
							array framePoly {
								Point;
							};
						
						case AppleReserved0076:
							key integer = $0076;
							integer = $$CountOf(framePoly) * 4 + 10;
							Rect;					/* enclosing rectangle */
							array framePoly {
								Point;
							};
						
						case AppleReserved0077:
							key integer = $0077;
							integer = $$CountOf(framePoly) * 4 + 10;
							Rect;					/* enclosing rectangle */
							array framePoly {
								Point;
							};
						
						case frameSamePoly:
							key integer = $0078;
	
						case paintSamePoly:
							key integer = $0079;
	
						case eraseSamePoly:
							key integer = $007A;
	
						case invertSamePoly:
							key integer = $007B;
	
						case fillSamePoly:
							key integer = $007C;
	
						case AppleReserved007D:
							key integer = $007D;
	
						case AppleReserved007E:
							key integer = $007E;
	
						case AppleReserved007F:
							key integer = $007F;
	
						case frameRgn:
							key integer = $0080;
	frameRgnStart2:			integer = (frameRgnEnd2[$$ArrayIndex(OpCodes)] - frameRgnStart2[$$ArrayIndex(OpCodes)]) >> 3;
							Rect;				/* region's enclosing rect */
							hex string [$$Word(frameRgnStart2[$$ArrayIndex(OpCodes)]) - 10];
	frameRgnEnd2:
						case paintRgn:
							key integer = $0081;
	paintRgnStart2:			integer = (paintRgnEnd2[$$ArrayIndex(OpCodes)] - paintRgnStart2[$$ArrayIndex(OpCodes)]) >> 3;
							Rect;				/* region's enclosing rect */
							hex string [$$Word(paintRgnStart2[$$ArrayIndex(OpCodes)]) - 10];
	paintRgnEnd2:
						case eraseRgn:
							key integer = $0082;
	eraseRgnStart2:			integer = (eraseRgnEnd2[$$ArrayIndex(OpCodes)] - eraseRgnStart2[$$ArrayIndex(OpCodes)]) >> 3;
							Rect;				/* region's enclosing rect */
							hex string [$$Word(eraseRgnStart2[$$ArrayIndex(OpCodes)]) - 10];
	eraseRgnEnd2:
						case invertRgn:
							key integer = $0083;
	invertRgnStart2:		integer = (invertRgnEnd2[$$ArrayIndex(OpCodes)] - invertRgnStart2[$$ArrayIndex(OpCodes)]) >> 3;
							Rect;				/* region's enclosing rect */
							hex string [$$Word(invertRgnStart2[$$ArrayIndex(OpCodes)]) - 10];
	invertRgnEnd2:
						case fillRgn:
							key integer = $0084;
	fillRgnStart2:			integer = (fillRgnEnd2[$$ArrayIndex(OpCodes)] - fillRgnStart2[$$ArrayIndex(OpCodes)]) >> 3;
							Rect;				/* region's enclosing rect */
							hex string [$$Word(fillRgnStart2[$$ArrayIndex(OpCodes)]) - 10];
	fillRgnEnd2:
						case AppleReserved0085:
							key integer = $0085;
	AppleReserved0085Start:integer = (AppleReserved0085End[$$ArrayIndex(OpCodes)] - AppleReserved0085Start[$$ArrayIndex(OpCodes)]) >> 3;
							Rect;				/* region's enclosing rect */
							hex string [$$Word(AppleReserved0085Start[$$ArrayIndex(OpCodes)]) - 10];
	AppleReserved0085End:
						case AppleReserved0086:
							key integer = $0086;
	AppleReserved0086Start:	integer = (AppleReserved0086End[$$ArrayIndex(OpCodes)] - AppleReserved0086Start[$$ArrayIndex(OpCodes)]) >> 3;
							Rect;				/* region's enclosing rect */
							hex string [$$Word(AppleReserved0086Start[$$ArrayIndex(OpCodes)]) - 10];
	AppleReserved0086End:
						case AppleReserved0087:
							key integer = $0087;
	AppleReserved0087Start:	integer = (AppleReserved0087End[$$ArrayIndex(OpCodes)] - AppleReserved0087Start[$$ArrayIndex(OpCodes)]) >> 3;
							Rect;				/* region's enclosing rect */
							hex string [$$Word(AppleReserved0087Start[$$ArrayIndex(OpCodes)]) - 10];
	AppleReserved0087End:
						case frameSameRgn:
							key integer = $0088;

						case paintSameRgn:
							key integer = $0089;

						case eraseSameRgn:
							key integer = $008A;

						case invertSameRgn:
							key integer = $008B;

						case fillSameRgn:
							key integer = $008C;

						case AppleReserved008D:
							key integer = $008D;

						case AppleReserved008E:
							key integer = $008E;

						case AppleReserved008F:
							key integer = $008F;

						case BitsRect:
							key integer = $0090;
							integer;		/* originSCB */
							integer;		/* B/W vs Color */
	BitsRectpMapRowBytes:	Integer;		/*width of pixel image	*/
	BitsRectBounds2:		rect;													/* Bitmap bounds		*/
							Rect;						/* srcRect */
							Rect;						/* destRect */
							integer		srcCopy, srcOr, srcXor, srcBic,	/* mode */
										notSrcCopy, notSrcOr, notSrcXor,
										notSrcBic, patCopy, patOr, patXor,
										patBic, notPatCopy, notPatOr, notPatBic,
										blend = 32, addPin, addOver, subPin,
										adMax = 37, subOver, adMin;
	BitsRectBits:			hex string [$$BitField(BitsRectpMapRowBytes[$$ArrayIndex(OpCodes)],0,13) *
										($$BitField(BitsRectBounds2[$$ArrayIndex(OpCodes)],32,16)
										- $$BitField(BitsRectBounds2[$$ArrayIndex(OpCodes)],0,16))];
						
						
						case BitsRgn:
							key integer = $0091;
							integer;		/* originSCB */
							integer;		/* B/W vs Color */
	BitsRgnpMapRowBytes:	integer;		/* width of pixel image */
	BitsRgnBounds2:			rect;			/* bounds rect */
							rect;			/* src rect */
							rect;			/* destrect */
							integer		srcCopy, srcOr, srcXor, srcBic,	/* mode */
										notSrcCopy, notSrcOr, notSrcXor,
										notSrcBic, patCopy, patOr, patXor,
										patBic, notPatCopy, notPatOr, notPatBic;
			BitsRectStart:	integer = (BitsRectEnd[$$ArrayIndex(OpCodes)] - BitsRectStart[$$ArrayIndex(OpCodes)]);
							hex string[$$Word(BitsRectStart[$$ArrayIndex(OpCodes)])];
			BitsRectEnd:
		
	BitsRgnStart2:			integer = (BitsRgnEnd2[$$ArrayIndex(OpCodes)] - BitsRgnStart2[$$ArrayIndex(OpCodes)]) >> 3;
							Rect;				/* region's enclosing rect */
							hex string [$$Word(BitsRgnStart2[$$ArrayIndex(OpCodes)]) - 10];
	BitsRgnEnd2:			hex string [$$PackedSize(BitsRgnEnd2[$$ArrayIndex(OpCodes)],
										$$BitField(BitsRgnpMapRowBytes[$$ArrayIndex(OpCodes)],0,13),
										($$BitField(BitsRgnBounds2[$$ArrayIndex(OpCodes)],32,16)
										- $$BitField(BitsRgnBounds2[$$ArrayIndex(OpCodes)],0,16)))];

						
						case LongComment:
							key integer = $00A1;
							integer;							/* comment kind */
	longCommentStart2:		integer = (longCommentEnd2[$$ArrayIndex(OpCodes)] - longCommentStart2[$$ArrayIndex(OpCodes)] - 16) >> 3;
							hex string [$$Word(longCommentStart2[$$ArrayIndex(OpCodes)])];
	longCommentEnd2:
						
				};
		};
};
